<?php
// api/update_version_label.php
// Version: 2025-02-06.2
// This endpoint updates a version record’s label and, if that label is the maximum
// for that document, updates the document’s current_version field as well.

require_once '../includes/functions.php';
requireLogin();
require_once '../config/db.php';

header('Content-Type: application/json');

// Ensure the request is POST.
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit();
}

// Validate the CSRF token.
if (!isset($_POST['csrf_token']) || !verifyToken($_POST['csrf_token'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid CSRF token.']);
    exit();
}

// Retrieve parameters.
$version_id = isset($_POST['version_id']) ? $_POST['version_id'] : '';
$new_label = isset($_POST['new_label']) ? trim($_POST['new_label']) : '';

if (empty($version_id) || $new_label === '') {
    echo json_encode(['success' => false, 'message' => 'Missing parameters.']);
    exit();
}

// Fetch the current version record.
$stmt = $pdo->prepare("SELECT document_id, version FROM versions WHERE id = ?");
$stmt->execute([$version_id]);
$versionRecord = $stmt->fetch();

if (!$versionRecord) {
    echo json_encode(['success' => false, 'message' => 'Version record not found.']);
    exit();
}

$old_label = $versionRecord['version'];
$document_id = $versionRecord['document_id'];

// Update the version record with the new label.
$stmt = $pdo->prepare("UPDATE versions SET version = ? WHERE id = ?");
if (!$stmt->execute([$new_label, $version_id])) {
    echo json_encode(['success' => false, 'message' => 'Failed to update version label.']);
    exit();
}

// Now, check the maximum version for this document.
$stmtMax = $pdo->prepare("SELECT MAX(version) AS max_version FROM versions WHERE document_id = ?");
$stmtMax->execute([$document_id]);
$row = $stmtMax->fetch();

// If the maximum version equals the new label, update the document’s current_version.
if ($row && $row['max_version'] == $new_label) {
    $stmtDoc = $pdo->prepare("UPDATE documents SET current_version = ? WHERE id = ?");
    $stmtDoc->execute([$new_label, $document_id]);
}

echo json_encode(['success' => true]);
exit();
