<?php
// api/load_document.php
require_once '../includes/functions.php';
requireLogin();
require_once '../config/db.php';

header('Content-Type: application/json');

$document_id = isset($_GET['document_id']) ? intval($_GET['document_id']) : 0;
$version = isset($_GET['version']) ? intval($_GET['version']) : 0;

if ($document_id <= 0 || $version <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid document information.']);
    exit();
}

// Verify the document belongs to the current user
$stmt = $pdo->prepare("SELECT id FROM documents WHERE id = ? AND user_id = ?");
$stmt->execute([$document_id, getCurrentUserId()]);
if (!$stmt->fetch()) {
    echo json_encode(['success' => false, 'message' => 'Document not found or access denied.']);
    exit();
}

// Retrieve the specified version’s content
$stmt = $pdo->prepare("SELECT content FROM versions WHERE document_id = ? AND version = ?");
$stmt->execute([$document_id, $version]);
$versionData = $stmt->fetch();
if (!$versionData) {
    echo json_encode(['success' => false, 'message' => 'Version not found.']);
    exit();
}

echo json_encode(['success' => true, 'content' => $versionData['content']]);
exit();
